/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : DUAL DECADE RIPPLE COUNTERS 
TRUTHTABLE     : 

          BCD COUNT SEQUENCE            BI-QUINARY COUNT SEQUENCE
            (SEE NOTE A)                     (SEE NOTE B)
         -------------------              -------------------   
         COUNT  QD.......QA               COUNT  QA QD....Q2
         -------------------              -------------------   
           0    L  L  L  L                  0    L  L  L  L     
           1    L  L  L  H                  1    L  L  L  H     
           2    L  L  H  L                  2    L  L  H  L     
           3    L  L  H  H                  3    L  L  H  H     
           4    L  H  L  L                  4    L  H  L  L     
           5    L  H  L  H                  5    H  L  L  L     
           6    L  H  H  L                  6    H  L  L  H     
           7    L  H  H  H                  7    H  L  H  L     
           8    H  L  L  L                  8    H  L  H  H     
           9    H  L  L  H                  9    H  H  L  L     
         -------------------              -------------------   

         NOTES : A. Q0 is connected to INPUT :CKB for BCD count.
                 B. Q3 is connected to INPUT :CKA for bi-quinary count.

REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : June 1994 

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a390 (cka, clr, qa, ckb, qb, qc, qd);
	parameter size =1;
	input
		clr,
		cka,
		ckb;
	output
		qa,
		qb,
		qc,
		qd;
    reg
        NOTIFY_REG1;
    not  
	  (m390_inst1_cka_, cka);
    not  
	  (m390_inst1_clrb, clr);
    nand
	M390_inst1_A2 (m390_inst1_wa2, ckb, m390_inst1_qdintb);
    nand
	M390_inst1_A3 (m390_inst1_wa3, ckb, m390_inst1_wr1);
    buf  
	  (qb, m390_inst1_qbint);
    U_AOI_2_2
	M390_inst1_INST9_inst1 (m390_inst1_wr1, m390_inst1_qbintb, m390_inst1_qdintb, m390_inst1_qcintb, m390_inst1_qdintb);
    U_FT_P_RB_NO_QN
	M390_inst1_Inst1_inst2 (m390_inst1_qaintb, m390_inst1_cka_, m390_inst1_clrb, NOTIFY_REG1);
    U_FT_P_RB_NO_QN
	M390_inst1_Inst2_inst2 (m390_inst1_qbintb, m390_inst1_wa2, m390_inst1_clrb, NOTIFY_REG1);
    U_FT_P_RB_NO_QN
	M390_inst1_Inst3_inst2 (m390_inst1_qcintb, m390_inst1_qbintb, m390_inst1_clrb, NOTIFY_REG1);
    U_FT_P_RB_NO_QN
	M390_inst1_Inst4_inst2 (m390_inst1_qdintb, m390_inst1_wa3, m390_inst1_clrb, NOTIFY_REG1);
    U_FT_P_RB_NO  
	M390_inst1_Inst5_inst1 (qa, m390_inst1_cka_, m390_inst1_clrb, NOTIFY_REG1);
    U_FT_P_RB_NO
	M390_inst1_Inst6_inst1 (m390_inst1_qbint, m390_inst1_wa2, m390_inst1_clrb, NOTIFY_REG1);
    U_FT_P_RB_NO  
	M390_inst1_Inst7_inst1 (qc, dd_net_40, m390_inst1_clrb, NOTIFY_REG1);
    U_FT_P_RB_NO  
	M390_inst1_Inst8_inst1 (qd, m390_inst1_wa3, m390_inst1_clrb, NOTIFY_REG1);
    buf  
	  (dd_net_40, m390_inst1_qbintb);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
